﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.IO;
using System.Text;

public partial class Admin_Template_ContentTemplate : System.Web.UI.Page
{
    private 访问 访问;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("内容模板管理", "网站后台", "内容模板管理", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void 增加模板()
    {
        访问.验证权限("55");
        String 模板名称=MoBanMingChen.Text;
        if (Directory.Exists(Server.MapPath("~/Template/Content/" + 模板名称)))
            throw new Exception("该模板名称已存在");

        Directory.CreateDirectory(Server.MapPath("~/Template/Content/" + 模板名称));
        创建文件夹(模板名称, "Content,Content_Aspx,ContentPage,Images,Other,Other_Aspx,Page,WapPage,SystemPage,SystemPage_Aspx,Adm_SystemPage_Aspx");
        Label2.Text = "增加模板成功";

        Response.Redirect("ContentTemplate.aspx");
    }

    private void 创建文件夹(String 模板名称,String 文件夹名称)
    {
        String[] 文件夹数组 = 文件夹名称.Split(',');
        for (int i = 0; i < 文件夹数组.Length; i++)
            Directory.CreateDirectory(Server.MapPath("~/Template/Content/" + 模板名称 + "/" + 文件夹数组[i]));
    }

    private void 导入模板()
    {
        访问.验证权限("55");
        HttpPostedFile HF = Request.Files[0];

        if (HF.ContentLength < 1)
            throw new Exception("请选择文件");

        String 模板名称 = Path.GetFileName(HF.FileName);

        if (!模板名称.EndsWith(".rar", StringComparison.OrdinalIgnoreCase))
            throw new Exception("模板文件格式不正确");

        模板名称 = 模板名称.Substring(0, 模板名称.Length - 4);

        if (Directory.Exists(Server.MapPath("~/Template/Content/" + 模板名称)))
            throw new Exception("该模板名称已存在");

        常用.上传文件(HF, Server.MapPath("~/Temp/" + 模板名称 + ".rar"));

        ZipC.UnZip(Server.MapPath("~/Temp/" + 模板名称 + ".rar"), Server.MapPath("~/Template/Content/"+模板名称+"/"), null);

        File.Delete(Server.MapPath("~/Temp/" + 模板名称 + ".rar"));

        Label2.Text = "导入模板成功";

        Response.Redirect("ContentTemplate.aspx");
    }

    private void 设为默认模板(String 模板名称)
    {
        访问.验证权限("55");
        String 当前程序模板 = 程序.设置["默认模板"].ToString();

        //删除当前模板数据
        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 当前程序模板 + "/Images/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
            FIS[i].Delete();

        FIS = new DirectoryInfo(Server.MapPath("~/Images/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
            FIS[i].CopyTo(Server.MapPath("~/Template/Content/" + 当前程序模板 + "/Images/"+FIS[i].Name));

        FIS = new DirectoryInfo(Server.MapPath("~/Images/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
            FIS[i].Delete();

        FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 当前程序模板 + "/WapPage/")).GetFiles("*.txt");
        for (int i = 0; i < FIS.Length; i++)
        {
            FileInfo FI = FIS[i];
            String 文件名 = FI.Name.Substring(0,FI.Name.Length-4);

            File.Delete(Server.MapPath("~/" + 文件名 + ".aspx"));
            File.Delete(Server.MapPath("~/" + 文件名 + ".aspx.cs"));
        }

        DirectoryInfo[] DIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 当前程序模板 + "/WapPage/")).GetDirectories();
        for (int i = 0; i < DIS.Length; i++)
            常用.删除文件夹(new DirectoryInfo(Server.MapPath("~/" + DIS[i].Name)));

        //结束

        //复制、生成新的文件

        FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 模板名称 + "/Images/")).GetFiles();
        for (int i = 0; i < FIS.Length; i++)
            FIS[i].CopyTo(Server.MapPath("~/Images/"+FIS[i].Name),true);

        生成ASPX文件(new DirectoryInfo(Server.MapPath("~/Template/Content/" + 模板名称 + "/WapPage/")), "",模板名称);

        //结束

        程序.设置["默认模板"] = 模板名称;
        File.WriteAllText(Server.MapPath("~/Data/XML/SheZhi.xml"), 程序.设置.生成XML(), Encoding.UTF8);

        Label2.Text = "设置默认模板成功";

        Response.Redirect("ContentTemplate.aspx");
    }

    private void 生成ASPX文件(DirectoryInfo DI, String 位置,String 模板名称)
    {
        FileInfo[] FIS = DI.GetFiles("*.txt");

        for (int i = 0; i < FIS.Length; i++)
        {
            FileInfo FI = FIS[i];
            StreamReader 读取 = FI.OpenText();
            String 第一行内容 = 读取.ReadLine();
            String 编译类型 = 读取.ReadLine();
            String 文件内容 = 读取.ReadToEnd();
            读取.Close();

            bool 是否WAP = 第一行内容.StartsWith("wap_", StringComparison.OrdinalIgnoreCase);
            String _位置 = 是否WAP ? 第一行内容.Substring(4) : 第一行内容.Substring(3);

            String ASPX代码, CS代码;

            编译器 编译器 = new 编译器(this.Context, 访问.连接, 编译类型, 是否WAP);
            编译器.模板名称 = 模板名称;
            编译器.文件名称 = 程序.安装位置 + 位置 + FI.Name.Substring(0, FI.Name.Length - 4) + ".aspx";
            编译器.开始执行代码 = 编译器.开始执行代码.Replace("$所在位置$", _位置)
            .Replace("$内容类型$", "网站页面")
            .Replace("$内容小类型$", _位置);
            CS代码 = 编译器.编译(文件内容, 位置 + FI.Name.Substring(0, FI.Name.Length - 4), out ASPX代码);

            File.WriteAllText(Server.MapPath("~/" + 位置 + FI.Name.Substring(0, FI.Name.Length - 4) + ".aspx"),
                ASPX代码, Encoding.UTF8);
            File.WriteAllText(Server.MapPath("~/" + 位置 + FI.Name.Substring(0, FI.Name.Length - 4) + ".aspx.cs"),
                CS代码, Encoding.UTF8);
        }

        DirectoryInfo[] DIS = DI.GetDirectories();
        for (int i = 0; i < DIS.Length; i++)
        {
            Directory.CreateDirectory(Server.MapPath("~/" + 位置 + DIS[i].Name));
            生成ASPX文件(DIS[i], 位置 + DIS[i].Name + "/",模板名称);
        }
    }

    private void 导出模板(String 模板名称)
    {
        访问.验证权限("55");
        if (模板名称 == 程序.设置["默认模板"].ToString())
        {
            FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 模板名称 + "/Images/")).GetFiles();
            for (int i = 0; i < FIS.Length; i++)
                FIS[i].Delete();

            FIS = new DirectoryInfo(Server.MapPath("~/Images/")).GetFiles();
            for (int i = 0; i < FIS.Length; i++)
                FIS[i].CopyTo(Server.MapPath("~/Template/Content/" + 模板名称 + "/Images/" + FIS[i].Name), true);
        }
        ZipC.Zip(Server.MapPath("~/Template/Content/" + 模板名称 + "/"), Server.MapPath("~/Temp/" + 模板名称 + ".rar"), null);
        Label2.Text = "导出模板成功，文件保存在临时文件夹(Temp)下，下载后建议删除该文件。";

        Response.Redirect("ContentTemplate.aspx");
    }

    private void 删除模板(String 模板名称)
    {
        访问.验证权限("55");
        if (模板名称 == 程序.设置["默认模板"].ToString())
            throw new Exception("默认模板不可删除");
        if (模板名称 == "默认模板")
            throw new Exception("默认模板不可删除");
        常用.删除文件夹(Server.MapPath("~/Template/Content/" + 模板名称 + "/"));
        Label2.Text = "删除模板成功";

        Response.Redirect("ContentTemplate.aspx");
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        switch (Request.QueryString["Action"])
        {
            case "SetTemp":
                设为默认模板(Request.QueryString["Name"]);
                break;
            case "ZipTemp":
                导出模板(Request.QueryString["Name"]);
                break;
            case "DelTemp":
                删除模板(Request.QueryString["Name"]);
                break;
        }

        String 模板代码 = @"<table class=""tab1"" border=""0"" cellpadding=""0"" cellspacing=""0"">
        <tr>
            <td>
                <table class=""tab2"" border=""0"" cellpadding=""0"" cellspacing=""0"">
                    <tr>
                        <td class=""tab2_bt"">
                            内容模板列表
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div>
	<table class=""tab3"" cellspacing=""1"" border=""0"" id=""GridView1"">
		<tr>
			<th scope=""col"" style=""width:30%;"">模板名称</th>
            <th scope=""col"" style=""width:10%;"">文件数</th>
            <th scope=""col"" style=""width:10%;"">内容模板数</th>
            <th scope=""col"" style=""width:10%;"">其它模板数</th>
            <th scope=""col"" style=""width:10%;"">分页模板数</th>
            <th scope=""col"" style=""width:10%;"">设为默认</th>
            <th scope=""col"" style=""width:10%;"">导出</th>
            <th scope=""col"" style=""width:10%;"">删除</th>
		</tr>
";
        DirectoryInfo[] DIS = new DirectoryInfo(Server.MapPath("~/Template/Content")).GetDirectories();
        for (int i = 0; i < DIS.Length; i++)
            模板代码 += 生成模板行(DIS[i]);

        模板代码 += @"
    </table>
            </div>
        </td>
    </tr>
    </table>
    </td>
    </tr>
</table><br/>
";
        Label1.Text = 模板代码;
    }

    private String 生成模板行(DirectoryInfo 文件夹)
    {
        String 模板名称 = 文件夹.Name;
        String 返回值 = "";

        String _模板名称 = 程序.设置["默认模板"].ToString() == 模板名称 ? "<strong>" + 模板名称 + "</strong>" : 模板名称;
        int 文件数 = 常用.获取文件数量(文件夹.GetDirectories("WapPage")[0]);
        int 内容模板数 = 常用.获取文件数量(文件夹.GetDirectories("Content")[0]);
        int 其它模板数 = 常用.获取文件数量(文件夹.GetDirectories("Other")[0]);
        int 分页模板数 = 常用.获取文件数量(文件夹.GetDirectories("Page")[0]);

        返回值 += "<tr>" +
            "<td>" + _模板名称 + "</td>" +
            "<td>" + 文件数 + "</td>" +
            "<td>" + 内容模板数 + "</td>" +
            "<td>" + 其它模板数 + "</td>" +
            "<td>" + 分页模板数 + "</td>" +
            "<td><a href=\"ContentTemplate.aspx?Action=SetTemp&Name="+Server.UrlEncode(模板名称)+"\">设为默认</a></td>" +
            "<td><a href=\"ContentTemplate.aspx?Action=ZipTemp&Name=" + Server.UrlEncode(模板名称) + "\">导出</a></td>" +
            "<td><a href=\"ContentTemplate.aspx?Action=DelTemp&Name=" + Server.UrlEncode(模板名称) + "\" onclick=\"if(!confirm('真的要删除吗？')){return false;}\">删除</a></td>" +
            "</tr>";

        return 返回值;
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        增加模板();
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        导入模板();
    }
}
